<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 09.01.14 16:27
 */

namespace VM\FinancialStatementsBundle\Services\Reports;


class FullReport
{
    protected $topMargin = 20;


    protected $leftMargin = 30;


    /**
     * @var GamePdf
     */
    protected $Pdf;

    /**
     * @var \stdClass
     */
    protected $Data;

    /**
     * @var int
     */
    protected $iteration = 1;


    /**
     * @var \DateTime
     */
    protected $Today;


    protected $labelWidth = 200;
    protected $priceWidth = 80;
    protected $cellHeight = 14;

    protected $x = 0;
    protected $y = 0;
    protected $xFirstColumn = 0;
    protected $xSecondColumn = 0;

    public function __construct(\stdClass $Data, $iteration = 1)
    {
        $this->Today = new \DateTime();
        $this->Data = $Data;
        $this->iteration = $iteration;
        $this->init();
        $this->setDefaultFont();
    }

    public function getPdf()
    {
        return $this->Pdf;
    }

    protected function init()
    {
        $this->Pdf = new GamePdf('P', 'px');
        $this->Pdf->SetMargins($this->leftMargin, $this->topMargin, $this->leftMargin, true);
        $this->Pdf->setHeaderMargin(120);
        $this->Pdf->setHeaderData('',0, $this->Data->companyName, 'Raport pełny');

        $this->xFirstColumn = $this->leftMargin;
        $this->xSecondColumn = $this->leftMargin + $this->priceWidth * 2 + $this->labelWidth + 57;

        $this->Pdf->AddPage('L', 'A4', true);
        $this->setDefaultFont();

        $this->y = $this->Pdf->getY();
        $this->aktywa();
        $this->pasywa();

        $this->Pdf->AddPage('L', 'A4', true);
        $this->rachunekZyskowIStart();
        $this->Pdf->AddPage('L', 'A4', true);
        $this->rachunekPrzeplywowPienieznych();
//        $this->Pdf->AddPage('L', 'A4', true);
//        $this->wskazniki();
    }


    protected function drawColumnLineSimple($label, $object = null, $indent = 0, $bold = false, $borderTop = false)
    {
        if(!empty($object))
        {
            $current = $this->iteration;
            $price = $object->$current;
            $prevIteration = $this->iteration - 1;
            $prevPrice = (isset($object->$prevIteration)) ? $object->$prevIteration : '--';
        }
        else
        {
            $price = $prevPrice = 0;
            if($this->iteration == 1)
            {
                $prevPrice = '--';
            }
        }
        $this->drawColumnLine($label, $price, $prevPrice, $indent, $bold, $borderTop);
    }


    protected function drawColumnLine($label, $price, $lastPrice, $indent = 0, $bold = false, $borderTop = false)
    {
        $this->Pdf->SetX($this->x);
        $this->setDefaultFont();
        if($bold)
        {
            $this->setDefaultBoldFont();
        }

        $labelWithIndent = str_repeat(' ', $indent * 4) . $label;
        $this->Pdf->MultiCell($this->labelWidth, $this->cellHeight, $labelWithIndent, 0, 'L', false, 0, '', '', true, 0, false, true, $this->cellHeight, 'M', true);
        if($borderTop)
        {
            $y = $this->Pdf->getY();
            $x = $this->Pdf->getX();
        }
        $this->Pdf->MultiCell($this->priceWidth, $this->cellHeight, $this->roundPrice($price), 0, 'R', false, 0, '', '', true, 0, false, true, $this->cellHeight, 'M', true);
        $this->Pdf->MultiCell($this->priceWidth, $this->cellHeight, ($lastPrice == '--') ? $lastPrice : $this->roundPrice($lastPrice), 0, 'R', false, 1, '', '', true, 0, false, true, $this->cellHeight, 'M', true);
        if($borderTop)
        {
            $this->Pdf->Line($x,$y,$x + 2 * $this->priceWidth,$y);
        }
    }


    protected function drawHeader($label, $indent = 0, $bold = true)
    {
        $this->Pdf->SetX($this->x);
        $this->setDefaultFont();
        if($bold)
        {
            $this->setDefaultBoldFont();
        }

        $labelWithIndent = str_repeat(' ', $indent * 4) . $label;
        $this->Pdf->MultiCell($this->labelWidth, $this->cellHeight, $labelWithIndent, 0, 'L', false, 1, '', '', true, 0, false, true, $this->cellHeight, 'M', true);
    }

    protected function drawColumnLabels()
    {
        $this->Pdf->SetX($this->x);
        $this->setDefaultFont();
        $this->setDefaultBoldFont();

        $labelFirstColumn = 'Tura ' . $this->iteration;
        $labelSecondColumn = ($this->iteration == 1) ? '' : 'Tura ' . ($this->iteration - 1);

        $this->Pdf->MultiCell($this->labelWidth, $this->cellHeight, '', 0, 'L', false, 0, '', '', true, 0, false, true, $this->cellHeight, 'M', true);
        $y = $this->Pdf->getY();
        $x = $this->Pdf->getX();
        $this->Pdf->MultiCell($this->priceWidth, $this->cellHeight, $labelFirstColumn, 0, 'R', false, 0, '', '', true, 0, false, true, $this->cellHeight, 'M', true);
        $this->Pdf->MultiCell($this->priceWidth, $this->cellHeight, $labelSecondColumn, 0, 'R', false, 1, '', '', true, 0, false, true, $this->cellHeight, 'M', true);

        $this->Pdf->Line($x,$y+$this->cellHeight,$x + 2 * $this->priceWidth,$y+$this->cellHeight);
    }

    protected function setDefaultFont()
    {
        $this->Pdf->SetFontSize(8);
        $this->Pdf->SetFont('dejavusanscondensed');
    }

    protected function setDefaultBoldFont()
    {
        $this->setDefaultFont();
        $this->Pdf->SetFont('', 'B');
    }


    protected function roundPrice($price)
    {
        return number_format($price, 2, ',', ' ');
    }

    protected function drawSpace($n = 1)
    {
        for($i = 1; $i <= $n; $i++)
        {
            $this->Pdf->Ln($this->cellHeight);
        }
    }



    protected function aktywa()
    {
        $this->x = $this->xFirstColumn;
        $this->drawHeader('AKTYWA');
        $this->drawColumnLabels();
        $this->drawColumnLineSimple('A. AKTYWA TRWAŁE', $this->Data->Aktywa->trwale->razem, 0, true);
        $this->drawSpace();
        $this->drawColumnLineSimple('I. Wartości niematerialne i prawne', null, 1, true);
        $this->drawColumnLineSimple('II. Rzeczowe aktywa trwałe', $this->Data->Aktywa->trwale->rzeczowe, 1, true);
        $this->drawColumnLineSimple('III. Należności długoterminowe', null, 1, true);
		$this->drawColumnLineSimple('IV. Inwestycje długoterminowe', $this->Data->Aktywa->trwale->inwestycjeDlugoterminowe, 1, true);
        $this->drawColumnLineSimple('V. Długoterminowe rozliczenia międzyokresowe', null, 1, true);
        $this->drawSpace(2);

        $this->drawColumnLineSimple('B. AKTYWA OBROTOWE', $this->Data->Aktywa->obrotowe->razem, 0, true);
        $this->drawSpace();
        $this->drawColumnLineSimple('I. Zapasy', $this->Data->Aktywa->obrotowe->zapasy, 1, true);
        $this->drawColumnLineSimple('II. Należności krótkoterminowe', $this->Data->Aktywa->obrotowe->naleznosciKrotkoterminowe->razem, 1, true);
        $this->drawColumnLineSimple('1. z tytułu dostaw i usług', $this->Data->Aktywa->obrotowe->naleznosciKrotkoterminowe->ztytDiU, 2, false);
        $this->drawColumnLineSimple('2. pozostałe', null, 2, false);
        $this->drawColumnLineSimple('III. Inwestycje krótkoterminowe', $this->Data->Aktywa->obrotowe->inwestycjeKrotkoterminowe, 1, true);
        $this->drawColumnLineSimple('IV. Krótkoterminowe rozliczenia międzyokresowe', null, 1, true);
        $this->drawSpace(6);
        $this->drawColumnLineSimple('RAZEM:', $this->Data->Aktywa->razem, 0, true, true);
        $this->drawSpace(6);
    }


    protected function pasywa()
    {
        $this->x = $this->xSecondColumn;
        $this->Pdf->SetY($this->y);
        $this->drawHeader('PASYWA');
        $this->drawColumnLabels();
        $this->drawColumnLineSimple('C. KAPITAŁ WŁASNY', $this->Data->Pasywa->kapitalWlasny->razem, 0, true);
        $this->drawSpace();
        $this->drawColumnLineSimple('I. Kapitał podstawowy', $this->Data->Pasywa->kapitalWlasny->podstawowy, 1, true);
        $this->drawColumnLineSimple('II. Kapitał zapasowy', null, 1, true);
        $this->drawColumnLineSimple('III. Pozostałe kapitały rezerwowe', null, 1, true);
        $this->drawColumnLineSimple('IV. Zysk (strata) z lat ubiegłych', $this->Data->Pasywa->kapitalWlasny->zyskZLatUbieglych, 1, true);
        $this->drawColumnLineSimple('IV. Zysk (strata) netto', $this->Data->Pasywa->kapitalWlasny->zyskNetto, 1, true);
        $this->drawSpace(2);
        $this->drawColumnLineSimple('D. ZOBOWIĄZANIA I REZERWY NA ZOBOWIĄZANIA', $this->Data->Pasywa->zobowiazania->razem, 0, true);
        $this->drawSpace();
        $this->drawColumnLineSimple('I. Rezerwy na zobowiązania', null, 1, true);
        $this->drawColumnLineSimple('II. Zobowiązania długoterminowe', $this->Data->Pasywa->zobowiazania->dlugoterminowe->razem, 1, true);
        $this->drawColumnLineSimple('1. kredyty i pożyczki', $this->Data->Pasywa->zobowiazania->dlugoterminowe->kredytyIPozyczki, 2);
        $this->drawColumnLineSimple('2. pozostałe', null, 2);
        $this->drawColumnLineSimple('III. Zobowiązania krótkoterminowe', $this->Data->Pasywa->zobowiazania->krotkoterminowe->razem, 1, true);
        $this->drawColumnLineSimple('1. z tytułu dostaw i usług', $this->Data->Pasywa->zobowiazania->krotkoterminowe->dostawyIUslugi, 2);
        $this->drawColumnLineSimple('2. kredyty i pożyczki', $this->Data->Pasywa->zobowiazania->krotkoterminowe->kredytyIPozyczki, 2);
        $this->drawColumnLineSimple('3. pozostałe', $this->Data->Pasywa->zobowiazania->krotkoterminowe->pozostale, 2);
        $this->drawColumnLineSimple('IV. Rozliczenia międzyokresowe', null, 1, true);
        $this->drawColumnLineSimple('1. dotacje', null, 2);
        $this->drawColumnLineSimple('2. pozostałe', null, 2);
        $this->drawSpace();
        $this->drawColumnLineSimple('RAZEM:', $this->Data->Pasywa->razem, 0, true, true);
        $this->drawSpace(6);
    }


    public function rachunekZyskowIStart()
    {
        $this->x = $this->xFirstColumn;
        $this->drawHeader('RACHUNEK ZYSKÓW I STRAT');
        $this->drawColumnLabels();
        $this->drawColumnLineSimple('A. PRZYCHODY NETTO ZE SPRZEDAŻY I ZRÓWNANE Z NIMI', $this->Data->RachunekZyskowIStrat->przychodyNettoZeSprzedazy->razem, 0, true);
        $this->drawSpace();
        $this->drawColumnLineSimple('I. Przychody netto ze sprzedaży produktów i usług', $this->Data->RachunekZyskowIStrat->przychodyNettoZeSprzedazy->produktow, 1, true);
        $this->drawColumnLineSimple('II. Zmiana stanu produktów', $this->Data->RachunekZyskowIStrat->przychodyNettoZeSprzedazy->zmianaStanuZapasow, 1, true);
        $this->drawSpace(2);
        $this->drawColumnLineSimple('B. KOSZTY DZIAŁALNOŚCI OPERACYJNEJ', $this->Data->RachunekZyskowIStrat->kosztyDzialalnosciOperacyjnej->razem, 0, true);
        $this->drawSpace();
        $this->drawColumnLineSimple('I. Amortyzacja', $this->Data->RachunekZyskowIStrat->kosztyDzialalnosciOperacyjnej->amortyzacja, 1, true);
        $this->drawColumnLineSimple('II. Zużycie materiałów i energii', $this->Data->RachunekZyskowIStrat->kosztyDzialalnosciOperacyjnej->zuzycieMaterialowIEnergii, 1, true);
        $this->drawColumnLineSimple('III. Usługi obce', $this->Data->RachunekZyskowIStrat->kosztyDzialalnosciOperacyjnej->uslugiObce, 1, true);
        $this->drawColumnLineSimple('IV. Podatki i opłaty', $this->Data->RachunekZyskowIStrat->kosztyDzialalnosciOperacyjnej->podatkiIOplaty, 1, true);
        $this->drawColumnLineSimple('V. Wynagrodzenie', $this->Data->RachunekZyskowIStrat->kosztyDzialalnosciOperacyjnej->wynagrodzenia, 1, true);
        $this->drawColumnLineSimple('VI. Ubezpieczenia społeczne i inne świadczenia', $this->Data->RachunekZyskowIStrat->kosztyDzialalnosciOperacyjnej->ubezpieczeniaSpoleczneISwiadczenia, 1, true);
        $this->drawColumnLineSimple('VII. Pozostałe koszty rodzajowe', null, 1, true);
        $this->drawColumnLineSimple('VIII. Wartość sprzedanych towarów i materiałów', null, 1, true);
        $this->drawSpace(2);
        $this->drawColumnLineSimple('C. Zysk (strata) ze sprzedaży', $this->Data->RachunekZyskowIStrat->zyskZeSprzedazy, 0, true);
        $this->drawSpace(2);
        $this->drawColumnLineSimple('D. Pozostałe przychody operacyjne', null, 0, true);
        $this->drawSpace();
        $this->drawColumnLineSimple('I. dotacje', null, 1, true);
        $this->drawColumnLineSimple('II. pozostałe przychody operacyjne', null, 1, true);

        $this->x = $this->xSecondColumn;
        $this->Pdf->SetY($this->y);
        $this->drawSpace(1);
        $this->drawColumnLabels();
        $this->drawColumnLineSimple('E. Pozostałe koszty operacyjne', null, 0, true);
        $this->drawSpace(2);
        $this->drawColumnLineSimple('F. Zysk (strata) z działalności operacyjnej', $this->Data->RachunekZyskowIStrat->zyskZDzialalnosciOperacyjnej, 0, true);
        $this->drawSpace(2);
        $this->drawColumnLineSimple('G. Przychody finansowe', $this->Data->RachunekZyskowIStrat->przychodyFinansowe, 0, true);
        $this->drawSpace(2);
        $this->drawColumnLineSimple('H. Koszty finansowe', $this->Data->RachunekZyskowIStrat->kosztyFinansowe, 0, true);
        $this->drawSpace(2);
        $this->drawColumnLineSimple('I. Zysk (strata) brutto', $this->Data->RachunekZyskowIStrat->zyskBrutto, 0, true);
        $this->drawSpace(2);
        $this->drawColumnLineSimple('J. Podatek dochodowy', $this->Data->RachunekZyskowIStrat->podatekDochodowy, 0, true);
        $this->drawSpace(2);
        $this->drawColumnLineSimple('K. Pozostałe obowiązkowe zmniejszenia zysku', null, 0, true);
        $this->drawSpace(2);
        $this->drawColumnLineSimple('L. Zysk (strata) netto', $this->Data->RachunekZyskowIStrat->zyskNetto, 0, true);
        $this->drawSpace(3);

    }


    protected function rachunekPrzeplywowPienieznych()
    {
        $this->x = $this->xFirstColumn;
        $this->Pdf->SetY($this->y);
        $this->drawHeader('RACHUNEK PRZEPŁYWÓW PIENIĘŻNYCH');
        $this->drawColumnLabels();
        $this->drawColumnLineSimple('A. PRZEPŁYWY ŚRODKÓW PIENIĘŻNYCH Z DZIAŁALNOŚCI OPERACYJNEJ', $this->Data->RachunekPrzeplywowPienieznych->przeplywySrodkowZDzialalnosciOperacyjnej->razem, 0, true);
        $this->drawSpace();
        $this->drawColumnLineSimple('I. Zysk (strata) netto', $this->Data->RachunekPrzeplywowPienieznych->przeplywySrodkowZDzialalnosciOperacyjnej->zyskNetto, 1, true);
        $this->drawColumnLineSimple('II. Korekty', $this->Data->RachunekPrzeplywowPienieznych->przeplywySrodkowZDzialalnosciOperacyjnej->korekty->razem, 1, true);
        $this->drawColumnLineSimple('1. amortyzacja', $this->Data->RachunekPrzeplywowPienieznych->przeplywySrodkowZDzialalnosciOperacyjnej->korekty->amortyzacja, 2, false);
        $this->drawColumnLineSimple('2. zmiana stanu zapasów', $this->Data->RachunekPrzeplywowPienieznych->przeplywySrodkowZDzialalnosciOperacyjnej->korekty->zmianaStanuZapasow, 2, false);
        $this->drawColumnLineSimple('3. zmiana stanu należności', $this->Data->RachunekPrzeplywowPienieznych->przeplywySrodkowZDzialalnosciOperacyjnej->korekty->zmianaStanuNaleznosci, 2, false);
        $this->drawColumnLineSimple('4. zmiana stanu zobowiązań krótkoterminowych', $this->Data->RachunekPrzeplywowPienieznych->przeplywySrodkowZDzialalnosciOperacyjnej->korekty->zmianaStanuZobowiazanKrotkoterminowych, 2, false);
        $this->drawColumnLineSimple('5. zmiana stanu rozliczeń międzyokresowych', null, 2, false);
        $this->drawColumnLineSimple('6. inne korekty', $this->Data->RachunekPrzeplywowPienieznych->przeplywySrodkowZDzialalnosciOperacyjnej->korekty->inneKorekty, 2, false);
        $this->drawSpace(2);
        $this->drawColumnLineSimple('B. PRZEPŁYWY ŚRODKÓW PIENIĘŻNYCH Z DZIAŁALNOŚCI INWESTYCYJNEJ', $this->Data->RachunekPrzeplywowPienieznych->przeplywySrodkowZDzialalnosciInwestycyjnej->razem, 0, true);
        $this->drawSpace();
        $this->drawColumnLineSimple('I. Zbycie wartości niematerialnych i prawnych, rzeczowych aktywów trwałych oraz inwestycji w nieruchomości', null, 1, true);
        $this->drawColumnLineSimple('II. Nabycie wartości niematerialnych i prawnych, rzeczowych aktywów trwałych oraz inwestycji w nieruchomości', $this->Data->RachunekPrzeplywowPienieznych->przeplywySrodkowZDzialalnosciInwestycyjnej->nakladyInwestycyjne, 1, true);
        $this->drawColumnLineSimple('III. Inne wpływy lub wydatki inwestycyjne', null, 1, true);
        $this->x = $this->xSecondColumn;
        $this->Pdf->SetY($this->y);
        $this->drawSpace(1);
        $this->drawColumnLabels();
        $this->drawColumnLineSimple('C. PRZEPŁYWY ŚRODKÓW PIENIĘŻNYCH Z DZIAŁALNOŚCI FINANSOWEJ', $this->Data->RachunekPrzeplywowPienieznych->przeplywySrodkowZDzialalnosciFinansowej->razem, 0, true);
        $this->drawSpace();
        $this->drawColumnLineSimple('I. Wpływy', $this->Data->RachunekPrzeplywowPienieznych->przeplywySrodkowZDzialalnosciFinansowej->wplywy->razem, 1, true);
        $this->drawColumnLineSimple('1. zaciągnięcie kredytów i pożyczek', $this->Data->RachunekPrzeplywowPienieznych->przeplywySrodkowZDzialalnosciFinansowej->wplywy->zaciagniecieKredytow, 2, false);
        $this->drawColumnLineSimple('2. wpłata kapitału własnego', null, 2, false);
        $this->drawColumnLineSimple('3. odsetki otrzymane', $this->Data->RachunekPrzeplywowPienieznych->przeplywySrodkowZDzialalnosciFinansowej->wplywy->odsetkiOtrzymane, 2, false);
        $this->drawColumnLineSimple('4. inne wpływy finansowe', $this->Data->RachunekPrzeplywowPienieznych->przeplywySrodkowZDzialalnosciFinansowej->wplywy->inneWplywy, 2, false);
        $this->drawColumnLineSimple('II. Wydatki', $this->Data->RachunekPrzeplywowPienieznych->przeplywySrodkowZDzialalnosciFinansowej->wydatki->razem, 1, true);
        $this->drawColumnLineSimple('1. spłaty kredytów i pożyczek', $this->Data->RachunekPrzeplywowPienieznych->przeplywySrodkowZDzialalnosciFinansowej->wydatki->splatyKredytow, 2, false);
        $this->drawColumnLineSimple('2. wypłaty na rzecz właścicieli', null, 2, false);
        $this->drawColumnLineSimple('3. odsetki zapłacone', $this->Data->RachunekPrzeplywowPienieznych->przeplywySrodkowZDzialalnosciFinansowej->wydatki->odsetkiZaplacone, 2, false);
 //       $this->drawColumnLineSimple('4. wypłaty na rzecz właścicieli', null, 2, false);
        $this->drawColumnLineSimple('4. inne wydatki finansowe', $this->Data->RachunekPrzeplywowPienieznych->przeplywySrodkowZDzialalnosciFinansowej->wydatki->inneWydatki, 2, false);
        $this->drawSpace(2);
        $this->drawColumnLineSimple('D. PRZEPŁYWY PIENIĘŻNE RAZEM', $this->Data->RachunekPrzeplywowPienieznych->przeplywyPieniezneRazem, 0, true);
        $this->drawSpace(2);
        $this->drawColumnLineSimple('E. ŚRODKI PIENIĘŻNE NA POCZĄTEK OKRESU', $this->Data->RachunekPrzeplywowPienieznych->srodkiNaPoczatekOkresu, 0, true);
        $this->drawSpace(2);
        $this->drawColumnLineSimple('F. ŚRODKI PIENIĘŻNE NA KONIEC OKRESU', $this->Data->RachunekPrzeplywowPienieznych->srodkiNaKoniecOkresu, 0, true);

    }


    public function wskazniki()
    {
        $this->x = $this->xFirstColumn;
        $this->Pdf->SetY($this->y);
        $this->drawHeader('WSKAŹNIKI FINANSOWE');
        $this->drawSpace();
        $this->drawColumnLineSimple('A. WSKAŹNIKI PŁYNNOŚCI', $this->Data->RachunekPrzeplywowPienieznych->przeplywySrodkowZDzialalnosciOperacyjnej->razem, 0, true);
        $this->drawSpace();

    }

}